import { useEffect } from 'react';

import { useScope } from './provider';
import { useStoreManager } from './store-manager-context';
import { AsyncStore, HydratableStore, Store, Type } from './types';

type AsyncLoadingResult = { data: null; isLoading: true };
type AsyncSuccessResult<T> = { data: Exclude<T, null>; isLoading: false };

type AsyncResult<T> = AsyncLoadingResult | AsyncSuccessResult<T>;

type StoreResult<T> = T extends AsyncStore<any> ? Omit<T, 'data'> & AsyncResult<T['data']> : T;

export function useStore<T extends Store>(Store: Type<T>): StoreResult<T>;
export function useStore<T extends HydratableStore>(Store: Type<T>): StoreResult<T> {
  const scope = useScope();
  const manager = useStoreManager();
  const store = manager.get(Store, scope);

  useEffect(() => {
    store.start?.();

    return () => {
      store.reset?.();
    };
  }, [store]);

  return store as StoreResult<T>;
}
