import { enableStaticRendering } from 'mobx-react-lite';
import RootApp from 'next/app';

import { getNextData } from '@client/shared/next';
import { NextApp } from '@shared/types/next-bridge';

import { Provider } from './provider';
import { StoreManager } from './store-manager';
import { StoreManagerProvider } from './store-manager-context';
import { canUseDom } from './utils';

enableStaticRendering(!canUseDom);

export function withHydrate<T>(WrappedApp: NextApp<T>) {
  const App: NextApp<T> = (props) => {
    const query = getNextData('query');
    const scope = canUseDom && query ? query : props.router.query;

    return (
      <StoreManagerProvider value={StoreManager.getInstance()}>
        <Provider value={scope}>
          <WrappedApp {...props} />
        </Provider>
      </StoreManagerProvider>
    );
  };

  const getInitialProps =
    WrappedApp.getInitialProps || (RootApp.getInitialProps as NextApp['getInitialProps']);

  App.getInitialProps = getInitialProps;

  return App;
}
