import NextLink, { LinkProps } from 'next/link';
import { AnchorHTMLAttributes, FC, RefObject } from 'react';

export interface RouterLinkProps extends AnchorHTMLAttributes<HTMLAnchorElement>, LinkProps {
  href: string;
  innerRef?: RefObject<HTMLAnchorElement>;
}

export const RouterLink: FC<RouterLinkProps> = (props) => {
  const { href, children, scroll, innerRef, ...restProps } = props;

  return (
    <NextLink href={href} scroll={scroll}>
      <a {...restProps} ref={innerRef}>
        {children}
      </a>
    </NextLink>
  );
};
