import Router from 'next/router';

export function removeQueryParams<T extends string>(keys: T[]): void {
  const query = { ...Router.query };

  for (const key of keys) {
    if (query[key]) {
      delete query[key];
    }
  }

  Router.replace({ pathname: Router.pathname, query }, undefined, { shallow: true, scroll: false });
}
