import { canUseDom } from '@client/shared/libs/can-use-dom';

interface LogFn {
  (message: string, error?: Error): void;
  (message: string, error?: Ya.Rum.Additional): void;
  (error: Error, additional?: Ya.Rum.Additional): void;
}

let Ya: typeof window.Ya;

export let Rum: typeof Ya.Rum;

if (canUseDom) {
  Ya = window.Ya;
  Rum = Ya?.Rum;
}

function getLogLevelFn(level: Ya.Rum.LogLevel): LogFn {
  return function logMessage(error: string | Error, additional?: Error | Ya.Rum.Additional): void {
    if (typeof error === 'string') {
      Ya?.Rum.logError({ level, message: error }, additional as Error);
    } else {
      Ya?.Rum.logError({ level, message: error.message, additional }, error);
    }
  } as LogFn;
}

export const logFatal = getLogLevelFn('critical');

export const logError = getLogLevelFn('error');

export const logWarn = getLogLevelFn('warn');

export const logDebug = getLogLevelFn('debug');
