// не использую деструктуризацию, чтобы поддержать больше браузеров — код не проходит компиляцию
(function (window) {
  function getPage() {
    return window.location.pathname.substring(1).replace(/\//g, '_');
  }

  const data = Ya.id;
  let isTouch = data.isTouch;

  const env = data.yenv === 'testing' || data.yenv === 'development' ? 'testing' : 'production';
  const slots = [];

  const additional = {
    uid: data.uid,
    lang: data.locale,
  };

  if (isTouch === undefined) {
    try {
      document.createEvent('TouchEvent');
      isTouch = true;
    } catch (err) {
      isTouch = false;
    }
  }

  const project = 'Yandex.Id';
  const platform = isTouch ? 'touch' : 'desktop';
  const clck = 'https://yandex.ru/clck/click';

  window.Ya.Rum.init(
    {
      beacon: true,
      clck: clck,
      reqid: data.reqid,
      sendClientUa: true,
      sendAutoElementTiming: true,
      sendAutoResTiming: true, // Автоматически отправлять Resource Timing для размеченных
      slots: slots,
    },
    {
      // region,
      rum_id: 'ru.' + project + '.' + platform,
      '-project': project,
      '-page': getPage(),
      '-platform': platform,
      '-version': data.version,
      '-env': env,
      '-uid': data.uid,
      '-additional': JSON.stringify(additional),
    },
  );

  window.Ya.Rum.initErrors({
    project: project,
    page: getPage(),
    reqid: data.reqid,
    platform: platform,
    version: data.version,
    env: env,
    additional: additional,
    loggedin: Boolean(data.uid),
    slots: slots,
    preventError: false,
    unhandledRejection: true,
    uncaughtException: true,
    traceUnhandledRejection: true,
    transform: function (error) {
      if (!error) {
        return false;
      }

      if (typeof error === 'string') {
        // eslint-disable-next-line no-param-reassign
        error = {
          message: error,
        };
      }

      error.page = getPage();

      return error;
    },
  });
})(window);
