import { useState } from 'react';

import { canUseDom } from '@use-platform/react/libs/dom-utils';
import { useIsomorphicLayoutEffect } from '@use-platform/react/libs/isomorphic-layout-effect';

export function useClientHeight() {
  const [clientHeight, setClientHeight] = useState<number | undefined>(
    canUseDom ? getClientHeight() : undefined,
  );

  useIsomorphicLayoutEffect(() => {
    const onWindowResize = () => {
      setClientHeight(getClientHeight());
    };

    window.addEventListener('resize', onWindowResize);

    return () => {
      window.removeEventListener('resize', onWindowResize);
    };
  }, []);

  return clientHeight;
}

function getClientHeight() {
  return window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
}
