import { useMemo } from 'react';

import { useDateFormatter } from '@use-platform/react';

const DEFAULT_FORMAT_OPTIONS: Intl.DateTimeFormatOptions = {
  day: 'numeric',
  month: 'long',
  hour: '2-digit',
  minute: '2-digit',
};

export function useTimestampFormat(timestamp: number) {
  const formatOptions = useMemo<Intl.DateTimeFormatOptions>(() => {
    const now = new Date();
    const date = new Date(timestamp);

    if (date.getFullYear() !== now.getFullYear()) {
      return {
        ...DEFAULT_FORMAT_OPTIONS,
        year: 'numeric',
      };
    }

    return DEFAULT_FORMAT_OPTIONS;
  }, [timestamp]);

  const formatter = useDateFormatter(formatOptions);

  return formatter.format(timestamp);
}
