import { canUseDom } from '@client/shared/libs/can-use-dom';
import { NextAppInitialProps } from '@shared/types/next-bridge';

type BaseNextData = typeof window.__NEXT_DATA__;

export interface NextData extends BaseNextData {
  props: NextAppInitialProps & {
    [key: string]: any;
  };
}

export function getNextData(key?: undefined): NextData | null;
export function getNextData<K extends keyof NextData>(key?: K): NextData[K] | null;
export function getNextData<K extends keyof NextData>(key?: K): NextData | NextData[K] | null {
  if (canUseDom) {
    const data = window.__NEXT_DATA__ as NextData;

    if (key) {
      return data[key];
    }

    return data;
  }

  return null;
}

export function getServerSideProps() {
  const props = getNextData('props');

  if (props) {
    return props.serverSideProps;
  }

  return null;
}
