import { ComponentType } from 'react';

import { DocumentRenderPage } from '@shared/types/next-bridge';

export function renderPageWithEnhance(
  enhance: <T extends {}>(App: ComponentType<T>) => ComponentType<T>,
  originalRenderPage: DocumentRenderPage,
): DocumentRenderPage {
  return async (params) => {
    const enhanceApp = typeof params === 'function' ? undefined : params?.enhanceApp;
    const enhanceComponent = typeof params === 'function' ? params : params?.enhanceComponent;

    return originalRenderPage({
      enhanceComponent,
      enhanceApp(App) {
        if (enhanceApp) {
          return enhance(enhanceApp(App));
        }

        return enhance(App);
      },
    });
  };
}
