import { FC } from 'react';

import { PageTemplate } from '@client/shared/ui-kit';
import { Footer } from '@client/widgets/Footer';
import { Header } from '@client/widgets/Header';
import { Navigation } from '@client/widgets/Navigation';

export const PageMainLayout: FC = (props) => {
  const { children } = props;

  return (
    <PageTemplate>
      <PageTemplate.Header>
        <Header />
      </PageTemplate.Header>
      <PageTemplate.Sidebar>
        <Navigation />
      </PageTemplate.Sidebar>
      {children}
      <PageTemplate.Footer>
        <Footer />
      </PageTemplate.Footer>
    </PageTemplate>
  );
};
