import { useEnvContext } from '../libs/env';

export function useAvatarsPath() {
  const { yenv } = useEnvContext();

  if (yenv === 'development' || yenv === 'testing') {
    return 'https://avatars.mdst.yandex.net';
  }

  return 'https://avatars.mds.yandex.net';
}

export function getAvatarUrl(avatarHost: string, avatarId: string, size = 'islands-200') {
  return `${avatarHost}/get-yapic/${avatarId}/${size}`;
}
