import { useRouter } from 'next/router';
import { useMemo } from 'react';

import { useEnvContext } from '@client/shared/libs/env';
import { YEnv } from '@shared/types/env';

export function useCurrentUrl() {
  const { tld, yenv } = useEnvContext();
  const router = useRouter();

  const origin = getOrigin(yenv, tld);
  const href = `${origin}${router.asPath}`;

  const url = useMemo(() => new URL(href), [href]);

  return url;
}

function getOrigin(yenv: YEnv, tld: string) {
  if (yenv === 'development') {
    return `https://localhost.msup.yandex.${tld}`;
  }

  if (yenv === 'rc') {
    return `https://passport-rc.yandex.${tld}`;
  }

  if (yenv === 'testing') {
    return `https://passport-test.yandex.${tld}`;
  }

  return `https://passport.yandex.${tld}`;
}
