import { useMemo } from 'react';

import { useEnvContext } from '@client/shared/libs/env';

const TLD_PLACEHOLDER = '{tld}';

const YANDEX_URL = `https://yandex.${TLD_PLACEHOLDER}`;
const REVIEWS_URL = `https://reviews.yandex.${TLD_PLACEHOLDER}`;
const ID_URL = `https://id.yandex.${TLD_PLACEHOLDER}`;

export function useExternalPaths() {
  const { tld } = useEnvContext();
  const yandexUrl = YANDEX_URL.replace(TLD_PLACEHOLDER, tld);
  const reviewsUrl = REVIEWS_URL.replace(TLD_PLACEHOLDER, tld);
  const idUrl = ID_URL.replace(TLD_PLACEHOLDER, tld);
  const praktikumUrl = `https://praktikum.yandex.${tld}`;
  const yandex360Url = `https://mail360.yandex.${tld}`;
  const plusUrl = `https://plus.yandex.${tld}`;

  return useMemo(() => {
    return {
      howtoprotectyourid: `${idUrl}/howtoprotectyourid`,
      plus: plusUrl,
      plusIsActive: `${plusUrl}/my/?from=yandexid`,
      plusIsInactive: `${plusUrl}/?from=yandexid`,
      praktikum: `${praktikumUrl}/?utm_source=partners&utm_medium=passport&utm_campaign=partners_passport`,
      supportId: `${yandexUrl}/support/id`,
      tuneCommon: `${yandexUrl}/tune/common`,
      ugcCabinet: `${reviewsUrl}/ugcpub/cabinet`,
      yandex360: `${yandex360Url}/?from=yandexid`,
    };
  }, [idUrl, praktikumUrl, yandexUrl, reviewsUrl, yandex360Url, plusUrl]);
}
