import { useMemo } from 'react';

export function useIdPaths() {
  return useMemo(() => {
    return {
      activity: '/security/activity',
      addresses: '/personal/addresses',
      bonus: '/personal/bonus',
      contacts: '/personal/contacts',
      dataManagement: '/personal/data',
      documents: '/personal/documents',
      family: '/family',
      gibdd: '/pay/gibdd',
      gibddDocument: (id: string) => `/pay/gibdd/settings/documents/${id}`,
      gibddSettings: '/pay/gibdd/settings',
      gibddAddVrc: '/pay/gibdd/settings/documents/add-vrc',
      gibddAddDl: '/pay/gibdd/settings/documents/add-dl',
      helpdesk: '/helpdesk',
      home: '/',
      passwords: '/personal/passwords',
      pay: '/pay',
      payAnchorBankCards: '/pay#bank-cards',
      payAnchorCashback: '/pay#cashback',
      payHistory: '/pay/history',
      payReceipts: '/pay/history/receipts',
      personal: '/personal',
      personalData: '/personal?dialog=personal-data',
      personalPublicData: '/personal#public-data',
      personalPublicId: '/personal?dialog=public-id',
      security: '/security',
      securityControlQuestion: '/security?dialog=control-question',
      securityEnterMethods: '/security/enter-methods',
      securityExternalAccesses: '/security#external-accesses',
      securityRecoveryMethods: '/security#recovery-methods',
      iframe: {
        gibdd: '/iframe/gibdd',
        gibddSettings: '/iframe/gibdd/settings',
        gibddAddVrc: '/iframe/gibdd/settings/documents/add-vrc',
        gibddAddDl: '/iframe/gibdd/settings/documents/add-dl',
        gibddDocument: (id: string) => `/iframe/gibdd/settings/documents/${id}`,
      },
    };
  }, []);
}
