import { useMemo } from 'react';

import { useEnvContext } from '@client/shared/libs/env';
import { YEnv } from '@shared/types/env';

export function usePassportPaths() {
  const { tld, yenv } = useEnvContext();

  const passportUrl = getPassportUrl(yenv, tld);

  return useMemo(() => {
    return {
      accesses2fa: `${passportUrl}/profile/access/2fa`,
      aliceSettings: `${passportUrl}/profile/alice-settings`,
      appPasswords: `${passportUrl}/profile/apppasswords-list `,
      bouns: `${passportUrl}/profile/bonus`,
      changePassword: `${passportUrl}/profile/password`,
      dataManagement: `${passportUrl}/profile/data`,
      deleteProfile: `${passportUrl}/passport?mode=delete&origin=passport_profile`,
      devices: `${passportUrl}/profile/devices`,
      emailAdd: `${passportUrl}/profile/emails/add`,
      emails: `${passportUrl}/profile/emails`,
      family: `${passportUrl}/profile/family`,
      kids: `${passportUrl}/profile/family/kids`,
      loginMethods: `${passportUrl}/profile?openLoginMethodModal=1`,
      orderHistory: `${passportUrl}/order-history`,
      gibdd: `${passportUrl}/order-history/gibdd`,
      passwords: `${passportUrl}/profile/passwords`,
      phones: `${passportUrl}/profile/phones`,
      profile: `${passportUrl}/profile`,
      promoMailing: `${passportUrl}/profile/subs`,
      publicId: `${passportUrl}/profile/publicid`,
      services: `${passportUrl}/profile/services`,
      social: `${passportUrl}/profile/social`,
      support: `${passportUrl}/support`,
      allAddresses: `${passportUrl}/profile/address`,
      public: `${passportUrl}/profile/public`,
      personalInfo: `${passportUrl}/profile/personal-info`,
      upgradeAccount: `${passportUrl}/profile/upgrade`,
      yandexKeyEnable: `${passportUrl}/profile/access/2fa`,
      yandexKeyDisable: `${passportUrl}/profile/access/2fa/disable`,
    };
  }, [passportUrl]);
}

function getPassportUrl(yenv: YEnv, tld: string) {
  if (yenv === 'rc') {
    return `https://passport-rc.yandex.${tld}`;
  }

  if (yenv === 'development' || yenv === 'testing') {
    return `https://passport-test.yandex.${tld}`;
  }

  return `https://passport.yandex.${tld}`;
}
