import { getServerSideProps } from '@client/shared/next';

export function getSocialBrokerUrl() {
  const serverSideProps = getServerSideProps();
  const tld = serverSideProps?.tld || 'ru';
  const yenv = serverSideProps?.yenv || 'production';

  if (yenv === 'development' || yenv === 'testing') {
    return `https://social-test.yandex.${tld}`;
  }

  return `https://social.yandex.${tld}`;
}

export function getSocialBrokerPaths() {
  const url = getSocialBrokerUrl();

  return {
    bindExternalAccountStart: `${url}/broker2/start`,
  };
}
