import { useMemo } from 'react';

export interface IYandexAppPaths {
  [x: string]: {
    ios: string;
    android: string;
  };
}

export function useYandexAppPaths(): IYandexAppPaths {
  return useMemo(() => {
    return {
      bonusCards: {
        ios: 'ya-search-app-open://?uri=bonuscards://cardlist?utm_source=yndxid',
        android: 'bonuscards://cardlist?utm_source=yndxid',
      },
      websitesPasswords: {
        ios: 'ya-search-app-open://?uri=personaldata%3A%2F%2Fpasswords',
        android: 'personal-data-manager://?screen=passwords',
      },
    };
  }, []);
}
