import { i18n } from './i18n';

const servicesKeyset = {
  afisha: () => i18n('Афиша'),
  bnpl: () => i18n('Сплит'),
  business: () => i18n('Бизнес'),
  drive: () => i18n('Драйв'),
  eats: () => i18n('Еда'),
  games: () => i18n('Игры'),
  health: () => i18n('Здоровье'),
  help_nearby: () => i18n('Помощь рядом'),
  invest: () => i18n('Инвестиции'),
  kinopoisk: () => i18n('Кинопоиск'),
  lavka: () => i18n('Лавка'),
  maps: () => i18n('Карты'),
  market: () => i18n('Маркет'),
  music: () => i18n('Музыка'),
  pay: () => i18n('Yandex Pay'),
  plus_360: () => i18n('Подписка Яндекс 360'),
  plus_points: () => i18n('Баллы Плюса'),
  plus_subscribe: () => i18n('Подписка Плюса'),
  plus: () => i18n('Плюс'),
  praktikum: () => i18n('Практикум'),
  realty: () => i18n('Недвижимость'),
  receipts: () => i18n('Мои чеки'),
  refill: () => i18n('Заправки'),
  surveys: () => i18n('Взгляд'),
  taxi: () => i18n('Go'),
  tips: () => i18n('Чаевые'),
  toloka: () => i18n('Толока'),
  travel: () => i18n('Путешествия'),
  unknown: () => i18n('Яндекс'),
  uslugi: () => i18n('Услуги'),
  yandex_account: () => i18n('Счёт в Яндексе'),
  my_purchase: () => i18n('Моя покупка'),
  yandexpay_purchase: () => i18n('Покупка с Yandex Pay'),
};

export type ServiceKeyType = keyof typeof servicesKeyset;

export const i18nServices = (key: ServiceKeyType) => {
  return servicesKeyset[key] && servicesKeyset[key]();
};
