import cx from 'classnames';
import { useRouter } from 'next/router';
import { FC, useCallback } from 'react';

import { ArrowShortBack, Close } from '@client/shared/icons';
import { Text } from '@yandex-id/components';
import { Button } from '@yandex-id/components/next';

import styles from './AppBar.module.css';

interface IAppBarProps {
  className?: string;
  state?: 'close' | 'back';
  title: string;
  onClose?: () => void;
}

export const AppBar: FC<IAppBarProps> = ({ className, state, title, onClose }) => {
  const router = useRouter();
  const onPress = useCallback(() => {
    if (state === 'close') {
      if (onClose) {
        onClose();

        return;
      }

      window?.yandex?.private.navigation.closeTabSelf();
    } else if (state === 'back') {
      router.back();
    }
  }, [state, router, onClose]);

  return (
    <div className={cx(styles.root, className)}>
      <div className={styles.beforeTitle}>
        <Button size="l" variant="clear" onPress={onPress}>
          {state === 'close' ? <Close /> : <ArrowShortBack />}
        </Button>
      </div>
      <div className={styles.title}>
        <Text className={styles.text} weight="bold" color="primary" overflow="ellipsis">
          {title}
        </Text>
      </div>
      <div className={styles.afterTitle} />
    </div>
  );
};
