import cx from 'classnames';
import { ComponentProps, FC } from 'react';

import { useDevice } from '@client/shared/hooks';
import { Button } from '@yandex-id/components/next/Button';

import styles from './ActionButton.module.css';

type ButtonProps = ComponentProps<typeof Button>;

interface ActionButtonProps extends Omit<ButtonProps, 'variant' | 'size'> {
  variant: 'primary' | 'secondary';
}

export const ActionButton: FC<ActionButtonProps> = (props) => {
  const { children, variant, className, ...otherProps } = props;
  const variants = {
    primary: 'raised',
    secondary: 'clear',
  } as const;

  const { isTouch } = useDevice();

  return (
    <Button
      size={isTouch ? 'm' : 'xl'}
      variant={variants[variant]}
      className={cx(styles.root, className)}
      {...otherProps}
    >
      {children}
    </Button>
  );
};
