import cx from 'classnames';
import { FC } from 'react';

import { createSlot, useSlots } from '@yandex-id/components/libs/slots';

import { ImageIcon } from '../ImageIcon';
import { ActionButton } from './ActionButton/ActionButton';

import styles from './BannerCard.module.css';

const TitleSlot = createSlot('BannerCard.Title');
const TextSlot = createSlot('BannerCard.Text');

const ActionsSlot = createSlot('BannerCard.Actions');

export type BannerColor = 'blue-100' | 'red-200' | 'orange-100';

export interface BannerCardProps {
  color: BannerColor;
  cover: StaticImageData | string;
}

const _BannerCard: FC<BannerCardProps> = (props) => {
  const { cover, color } = props;

  const slots = useSlots(props);

  const title = slots.get(TitleSlot);
  const text = slots.get(TextSlot);
  const actions = slots.get(ActionsSlot);

  return (
    <div className={cx(styles.root, styles[`root_color-${color}`])} tabIndex={0}>
      <div className={styles.heading}>
        {title && <div className={styles.title}>{title.rendered}</div>}
        <div className={styles.text}>{text?.rendered}</div>
      </div>
      {actions && <div className={styles.actions}>{actions.rendered}</div>}
      <div className={styles.cover}>
        <ImageIcon src={cover} size={340} />
      </div>
    </div>
  );
};

export const BannerCard = Object.assign(_BannerCard, {
  Title: TitleSlot,
  Text: TextSlot,
  Actions: ActionsSlot,
  Button: ActionButton,
});
