import { ComponentProps } from 'react';

import { component } from '@yandex-id/components/libs/css-modules';
import { Button as _Button } from '@yandex-id/components/next/Button';

import shapeCircle from './_shape/shape-circle.module.css';

export { TextButton } from '@yandex-id/components/next/Button';

export type ButtonProps = ComponentProps<typeof Button>;

export const Button = component(_Button, {
  displayName: 'Button',
  defaultProps: {
    size: 'm',
    variant: 'default',
    shape: undefined,
  },
  variants: {
    shape: {
      circle: shapeCircle.root,
    },
  },
});
