import cx from 'classnames';
import { FC, HTMLAttributes } from 'react';

import styles from './Actions.module.css';

export type ActionsProps = HTMLAttributes<HTMLDivElement>;

export const Actions: FC<ActionsProps> = (props) => {
  const { children, className, ...otherProps } = props;

  return (
    <div className={cx(styles.root, className)} {...otherProps}>
      {children}
    </div>
  );
};
