import cx from 'classnames';
import { FC, HTMLAttributes } from 'react';

import { createSlot, useSlots } from '@yandex-id/components/libs/slots';

import { Actions, ActionsProps } from './Actions';
import { Content, ContentProps } from './Content';
import { Media, MediaProps } from './Media';

import styles from './CardTemplate.module.css';

export type CardTemplateProps = HTMLAttributes<HTMLDivElement>;

const MediaSlot = createSlot<MediaProps>('CardTemplate.Media');

const ContentSlot = createSlot<ContentProps>('CardTemplate.Content');

const ActionsSlot = createSlot<ActionsProps>('CardTemplate.Actions');

const CardTemplate: FC<CardTemplateProps> = (props) => {
  const { className, ...otherProps } = props;
  const slots = useSlots(props);

  const media = slots.get(MediaSlot);
  const content = slots.get(ContentSlot);
  const actions = slots.get(ActionsSlot);

  return (
    <div className={cx(styles.root, className)} {...otherProps}>
      {media && <Media {...media.props}>{media.rendered}</Media>}
      {content && <Content {...content.props}>{content.rendered}</Content>}
      {slots.children}
      {actions && <Actions {...actions.props}>{actions.rendered}</Actions>}
    </div>
  );
};

const _CardTemplate = Object.assign(CardTemplate, {
  Media: MediaSlot,
  Content: ContentSlot,
  Actions: ActionsSlot,
});

export { _CardTemplate as CardTemplate };
