import cx from 'classnames';
import { FC, HTMLAttributes } from 'react';

import styles from './Content.module.css';

export interface ContentProps extends HTMLAttributes<HTMLDivElement> {
  align?: 'start' | 'center' | 'end';
}

export const Content: FC<ContentProps> = (props) => {
  const { children, align = 'start', className, ...otherProps } = props;

  return (
    <div className={cx(styles.root, styles[`align_${align}`], className)} {...otherProps}>
      {children}
    </div>
  );
};
