import cx from 'classnames';
import { FC, HTMLAttributes } from 'react';

import styles from './Media.module.css';

export type MediaProps = HTMLAttributes<HTMLDivElement>;

export const Media: FC<MediaProps> = (props) => {
  const { children, className, ...otherProps } = props;

  return (
    <div className={cx(styles.root, className)} {...otherProps}>
      {children}
    </div>
  );
};
