import cx from 'classnames';
import { VFC, useCallback } from 'react';

import { DateInputChangeEvent, mergeProps, useLabel } from '@use-platform/react';
import { DateTimeField } from '@yandex-id/components';
import { DateTimeFieldProps } from '@yandex-lego/components/next/DateTimeField';

import styles from './DateField.module.css';

export interface DateFieldProps extends DateTimeFieldProps {
  label?: string;
  size?: 's' | 'm' | 'l' | 'xl';
  onChangeValue?: (value: Date | null) => void;
}

export const DateField: VFC<DateFieldProps> = (props) => {
  const { className, label, onChange, onChangeValue, ...restProps } = props;
  const { labelProps, fieldProps } = useLabel();

  const handleOnChange = useCallback(
    (event: DateInputChangeEvent<Date | null>) => {
      onChange?.(event);
      onChangeValue?.(event.value);
    },
    [onChange, onChangeValue],
  );

  return (
    <div className={cx(styles.root, className)}>
      {label && (
        <label {...labelProps} className={styles.label}>
          {label}
        </label>
      )}
      <DateTimeField {...mergeProps(restProps, fieldProps)} onChange={handleOnChange} />
    </div>
  );
};
