import { FC, useCallback } from 'react';

import { useDevice } from '@client/shared/hooks';

import { Drawer } from '../Drawer';
import { Modal } from '../Modal';

export interface DialogProps {
  className?: string;
  hasClose?: boolean;
  keepMounted?: boolean;
  onClose?: () => void;
  onCloseEnd?: () => void;
  visible?: boolean;
  zIndex?: number;
}

export const Dialog: FC<DialogProps> = (props) => {
  const { children, hasClose, onClose, onCloseEnd, ...otherProps } = props;
  const { isTouch } = useDevice();

  const handleOnClose = useCallback(() => {
    onClose?.();
    onCloseEnd?.();
  }, [onClose, onCloseEnd]);

  if (isTouch) {
    return (
      <Drawer {...otherProps} onClose={onClose} onCloseEnd={onCloseEnd}>
        {children}
      </Drawer>
    );
  }

  return (
    <Modal hasClose={hasClose} onClose={handleOnClose} {...otherProps}>
      {children}
    </Modal>
  );
};
