import React, { FC } from 'react';

import { Market, Q } from '../../icons';

import styles from './Example.module.css';

export type IExampleType = 'q' | 'market';

export interface IExampleProps {
  type: IExampleType;
  id: string;
}

const getIconByType = (type: IExampleType) => {
  switch (type) {
    case 'q':
      return <Q size={24} />;
    case 'market':
      return <Market size={24} />;
    default:
      return null;
  }
};

const getUrlByType = (type: IExampleType) => {
  switch (type) {
    case 'q':
      return 'yandex.ru/q/';
    case 'market':
      return 'market.yandex.ru/user/';
    default:
      return '';
  }
};

export const Example: FC<IExampleProps> = ({ type, id }) => (
  <div className={styles.root}>
    <div className={styles.iconWrapper}>{getIconByType(type)}</div>
    <span className={styles.urlService}>{getUrlByType(type)}</span>
    <span className={styles.urlId}>{id}</span>
  </div>
);
