import cx from 'classnames';
import throttle from 'lodash/throttle';
import { FC, useEffect, useRef, useState } from 'react';
import { createPortal } from 'react-dom';

import { canUseDom } from '@client/shared/libs/can-use-dom';

import styles from './FloatContainer.module.css';

const SCROLL_DELAY = 300;

export const FloatContainer: FC = (props) => {
  const { children } = props;
  const scrollYRef = useRef(0);
  const [isVisible, setVisible] = useState(true);

  useEffect(() => {
    const onScroll = throttle(() => {
      const maxScrollY = document.documentElement.scrollHeight - window.innerHeight;
      const scrollY = Math.min(Math.max(window.scrollY, 0), maxScrollY);
      const lastScrollY = Math.min(scrollYRef.current, maxScrollY);

      // TODO: Добавить threshold для показа.
      setVisible(scrollY < lastScrollY || scrollY === 0);
      scrollYRef.current = scrollY;
    }, SCROLL_DELAY);

    window.addEventListener('scroll', onScroll);

    return () => {
      window.removeEventListener('scroll', onScroll);
    };
  }, []);

  return canUseDom
    ? createPortal(
        <div
          className={cx(styles.root, {
            [styles.root_isVisible]: isVisible,
          })}
        >
          {children}
        </div>,
        document.body,
      )
    : null;
};
