import { FC, FormEvent, FormHTMLAttributes, useCallback } from 'react';

export const Form: FC<FormHTMLAttributes<HTMLFormElement>> = (props) => {
  const { onSubmit, children, ...otherProps } = props;

  const handleOnSubmit = useCallback(
    (event: FormEvent<HTMLFormElement>) => {
      event.preventDefault();
      onSubmit?.(event);
    },
    [onSubmit],
  );

  return (
    <form onSubmit={handleOnSubmit} {...otherProps}>
      {children}
    </form>
  );
};
