import cn from 'classnames';
import { HTMLAttributes, forwardRef } from 'react';

import styles from './Grid.module.css';

export type GridProps = HTMLAttributes<HTMLDivElement>;

export const Grid = forwardRef<HTMLDivElement, GridProps>((props, ref) => {
  const { children, className, ...otherProps } = props;

  return (
    <div ref={ref} className={cn(styles.root, className)} {...otherProps}>
      {children}
    </div>
  );
});
