/**
 *  nw ++ n ++ ne
 *  +           +
 *  w           e
 *  +           +
 *  sw ++ s ++ se
 */
export type CropOrd = 'nw' | 'n' | 'ne' | 'e' | 'se' | 's' | 'sw' | 'w';

export interface Point {
  x: number;
  y: number;
}

export interface BoxSize {
  width: number;
  height: number;
}

export interface Rect extends BoxSize {
  top: number;
  left: number;
}

export interface RelativeRect extends BoxSize {
  top: 'center';
  left: 'center';
}

export interface ImageInfo {
  size: BoxSize;
  offset: Point;
  scale: number;
}

export interface CropOptions {
  aspect?: number;
  minWidth?: number;
  maxWidth?: number;
  minHeight?: number;
  maxHeight?: number;
}
