import Image, { ImageProps } from 'next/image';
import { VFC } from 'react';

export interface ImageIconProps {
  src: ImageProps['src'];
  size?: number;
  quality?: number;
}

export const ImageIcon: VFC<ImageIconProps> = (props) => {
  const { src, size = 32, quality = 100 } = props;

  return <Image src={src} layout="fixed" width={size} height={size} quality={quality} />;
};
