import cx from 'classnames';
import { ComponentProps, FC } from 'react';

import { useIosBottomPanelFreeze } from '@client/shared/hooks/use-ios-bottom-panel-freeze';
import { Close } from '@client/shared/icons';
import { useClientHeight } from '@client/shared/libs/use-client-height';
import { Modal as BaseModal } from '@yandex-id/components/components/Modal';
import { createSlot, useSlots } from '@yandex-id/components/libs/slots';
import { Button } from '@yandex-id/components/next';
import { useTheme } from '@yandex-id/design-system';

import styles from './ImagePresenter.module.css';

const ImageSlot = createSlot('ImagePresenter.Image');
const BottomControlsSlot = createSlot('ImagePresenter.BottomControls');
const FloatingControlsSlot = createSlot('ImagePresenter.BottomControls');
const TitleSlot = createSlot('ImagePresenter.Title');

const ImagePresenter: FC<ComponentProps<typeof BaseModal>> = (props) => {
  const { children, className, onClose, ...restProps } = props;
  const { visible } = props;
  const slots = useSlots(props);
  const image = slots.get(ImageSlot);
  const bottomControls = slots.get(BottomControlsSlot);
  const floatingControls = slots.get(FloatingControlsSlot);
  const title = slots.get(TitleSlot);
  const { themeProps } = useTheme({ theme: 'default', colorScheme: 'dark' });
  const clientHeight = useClientHeight();

  useIosBottomPanelFreeze(visible);

  if (!image) {
    return null;
  }

  return (
    <BaseModal
      {...restProps}
      onClose={onClose}
      {...themeProps}
      className={cx(styles.root, className)}
    >
      <div
        className={cx(styles.content, { [styles.searchAppContent]: Boolean(title) })}
        style={{ height: clientHeight }}
      >
        {!title && (
          <Button
            size="xl"
            variant="clear"
            className={styles.closeButton}
            // eslint-disable-next-line react/jsx-no-bind
            onPress={() => onClose?.({} as MouseEvent, 'click')}
          >
            <Close />
          </Button>
        )}
        {title && title.rendered}
        <div className={styles.image}>
          {image.rendered}
          {floatingControls && (
            <div className={styles.floatingControls}>{floatingControls.rendered}</div>
          )}
        </div>
        {bottomControls && <div className={styles.bottomControls}>{bottomControls.rendered}</div>}
      </div>
    </BaseModal>
  );
};

const _ImagePresenter = Object.assign(ImagePresenter, {
  Image: ImageSlot,
  BottomControls: BottomControlsSlot,
  FloatingControls: FloatingControlsSlot,
  Title: TitleSlot,
});

export { _ImagePresenter as ImagePresenter };
