import cx from 'classnames';
import { FC } from 'react';

import { RouterLink, RouterLinkProps } from '@client/shared/libs/router-link';
import { mergeProps, useHover } from '@use-platform/react';

import styles from './Link.module.css';

export const Link: FC<RouterLinkProps> = (props) => {
  const { children, className, ...restProps } = props;
  const { hoverProps, isHovered } = useHover({});

  return (
    <RouterLink
      {...mergeProps(restProps, hoverProps)}
      className={cx(
        styles.root,
        {
          [styles.root_isHovered]: isHovered,
        },
        className,
      )}
    >
      {children}
    </RouterLink>
  );
};
