import { component } from '@yandex-id/components/libs/css-modules';

import { Link as UnstyledLink } from './Link';

import sizeInherit from './_size/size-inherit.module.css';
import sizeS from './_size/size-s.module.css';
import variantDefault from './_variant/variant-default.module.css';

export const Link = component(UnstyledLink, {
  displayName: 'Link',
  defaultProps: {
    size: 'inherit',
    variant: 'default',
  },
  variants: {
    size: {
      inherit: sizeInherit.root,
      s: sizeS.root,
    },
    variant: {
      default: variantDefault.root,
    },
  },
});
