import cx from 'classnames';
import { Children, ForwardedRef, Fragment, ReactNode, forwardRef } from 'react';

import { ListItemDivider } from './ListItemDivider';

import styles from './List.module.css';

interface ListProps {
  children: ReactNode;
  className?: string;
  hideDivider?: boolean;
}

function _List(props: ListProps, forwardedRed: ForwardedRef<HTMLDivElement>) {
  const { children, hideDivider } = props;

  const childs = Children.toArray(children);
  const content = childs.map((child, index) => {
    const showDivider = index !== childs.length - 1 && !hideDivider;

    return (
      <Fragment key={index}>
        {child}
        {showDivider && <ListItemDivider />}
      </Fragment>
    );
  });

  return (
    <div className={cx(styles.root, props.className)} ref={forwardedRed}>
      {content}
    </div>
  );
}

export const List = forwardRef(_List);
