import { VFC } from 'react';

import { ArrowShortForward, MoreVertical, Plus } from '@client/shared/icons';

import { ListItem, ListItemProps } from './ListItem';

type ListItemActionType = 'add' | 'kebab' | 'link';

interface ListItemActionProps extends ListItemProps {
  type: ListItemActionType;
}

const types: Record<ListItemActionType, VFC> = {
  add: Plus,
  kebab: MoreVertical,
  link: ArrowShortForward,
};

export const ListItemAction: VFC<ListItemActionProps> = (props) => {
  const { type, ...restProps } = props;
  const AfterType = types[type];

  return <ListItem {...restProps} after={<AfterType />} />;
};
