import { VFC } from 'react';

import { ArrowShortForward, Plus } from '@client/shared/icons';
import { RouterLink } from '@client/shared/libs/router-link';

import { ListItem, ListItemProps } from './ListItem';

type ListItemLinkType = 'add' | 'link' | 'default';

export interface ListItemLinkProps extends ListItemProps<typeof RouterLink> {
  type?: ListItemLinkType;
}

const DefaultIcon = () => <></>;

const types: Record<ListItemLinkType, VFC> = {
  add: Plus,
  link: ArrowShortForward,
  default: DefaultIcon,
};

export const ListItemLink: VFC<ListItemLinkProps> = (props) => {
  const { type = 'link', ...restProps } = props;
  const AfterType = types[type];

  return (
    <ListItem {...restProps} as={RouterLink} role="link" after={props.after || <AfterType />} />
  );
};
