import { ElementType, ReactElement, VFC } from 'react';

import { Radio } from '@yandex-id/components';

import { ListItem, ListItemProps } from './ListItem';

import styles from './List.module.css';

interface ListItemRadioProps<T extends ElementType = 'div'> extends ListItemProps<T> {
  isChecked: boolean;
}

interface ListItemRadioComponent extends Pick<VFC, keyof VFC> {
  <T extends ElementType = 'div'>(props: ListItemRadioProps<T>): ReactElement | null;
}

export const ListItemRadio: ListItemRadioComponent = (props) => {
  const { isChecked, ...restProps } = props;

  return (
    <ListItem
      {...restProps}
      after={<Radio className={styles.radio} tabIndex={-1} checked={isChecked} />}
    />
  );
};
