import { VFC } from 'react';

import { Tumbler } from '@yandex-id/components';

import { ListItem, ListItemProps } from './ListItem';

interface ListItemToggleProps extends ListItemProps {
  isChecked: boolean;
}

const noop = () => null;

export const ListItemToggle: VFC<ListItemToggleProps> = (props) => {
  const { isChecked, disabled, ...restProps } = props;

  return (
    <ListItem
      disabled={disabled}
      {...restProps}
      after={
        <Tumbler
          view="default"
          size="m"
          tabIndex={-1}
          checked={isChecked}
          onChange={noop}
          disabled={disabled}
        />
      }
    />
  );
};
