import cx from 'classnames';
import { FC, Fragment } from 'react';

import { ListItemSkeleton } from './ListItemSkeleton';

import styles from './List.module.css';

export interface ListSkeletonProps {
  className?: string;
  count?: number;
}

export const ListSkeleton: FC<ListSkeletonProps> = (props) => {
  const { count = 1, className } = props;

  if (count < 1) {
    throw new Error('Count should be more or equal to 1');
  }

  const content = Array.from({ length: count }, (_, index) => {
    const isLast = index === count - 1;

    return (
      <Fragment key={index}>
        <ListItemSkeleton />
        {!isLast && <span className={styles.divider} />}
      </Fragment>
    );
  });

  return <div className={cx(styles.root, className)}>{content}</div>;
};
