import cx from 'classnames';
import { ComponentProps, FC } from 'react';

import { Modal as BaseModal } from '@yandex-id/components/components/Modal';
import { component } from '@yandex-id/components/libs/css-modules';
import { Button } from '@yandex-id/components/next/Button';
import { Close } from '@yandex/ui-icons';

import { i18n } from './i18n';

import styles from './Modal.module.css';

export interface ModalProps extends ComponentProps<typeof BaseModal> {
  hasClose?: boolean;
  closeButtonPosition?: 'start' | 'end';
}

const _Modal: FC<ModalProps> = (props) => {
  const { children, hasClose = true, onClose, closeButtonPosition, ...restProps } = props;

  return (
    <BaseModal {...restProps} onClose={onClose}>
      {hasClose && (
        <Button
          size="xl"
          variant="clear"
          className={cx(styles.closeButton, {
            [styles.closeButtonLeftSided]: closeButtonPosition === 'start',
          })}
          // eslint-disable-next-line react/jsx-no-bind
          onPress={() => onClose?.({} as MouseEvent, 'click')}
          aria-label={i18n('Закрыть')}
        >
          <Close />
        </Button>
      )}
      {children}
    </BaseModal>
  );
};

export const Modal = component(_Modal, {
  displayName: 'Modal',
  styles: styles.root,
});
