import { FC } from 'react';

import { createSlot, useSlots } from '@yandex-id/components/libs/slots';

import styles from './PageTemplate.module.css';

const HeaderSlot = createSlot('PageTemplate.Header');
const SidebarSlot = createSlot('PageTemplate.Sidebar');
const FooterSlot = createSlot('PageTemplate.Footer');

const _PageTemplate: FC = (props) => {
  const slots = useSlots(props);

  const header = slots.get(HeaderSlot);
  const sidebar = slots.get(SidebarSlot);
  const footer = slots.get(FooterSlot);

  return (
    <div className={styles.root}>
      {header?.rendered}
      <div className={styles.sidebar}>{sidebar?.rendered}</div>
      <main className={styles.content}>{slots.children}</main>
      {footer?.rendered}
    </div>
  );
};

export const PageTemplate = Object.assign(_PageTemplate, {
  Header: HeaderSlot,
  Sidebar: SidebarSlot,
  Footer: FooterSlot,
});
