import { FC } from 'react';

import { Link as Anchor } from '@client/shared/icons';
import { useIsomorphicLayoutEffect as useLayoutEffect } from '@use-platform/react/libs/isomorphic-layout-effect';
import { Text, TextProps } from '@yandex-id/components';

import { Link } from '../Link';

import styles from './Title.module.css';

export interface TitleProps extends Pick<TextProps, 'variant' | 'weight'> {
  isHeading?: boolean;
  anchor?: string;
}

export const Title: FC<TitleProps> = (props) => {
  const { children, anchor, isHeading, variant = 'heading-m', weight } = props;
  const link = `#${anchor}`;

  useLayoutEffect(() => {
    const hash = window.location.hash;

    if (hash === link) {
      document.getElementById(hash)?.scrollIntoView({ behavior: 'smooth' });
    }
  });

  return (
    <Text
      as={isHeading ? 'h1' : 'h2'}
      variant={isHeading ? 'heading-l' : variant}
      weight={weight}
      className={styles.root}
      id={anchor}
    >
      {anchor && (
        <Link href={link} className={styles.anchor}>
          <Anchor size={16} />
        </Link>
      )}
      {children}
    </Text>
  );
};
