import { FC, useEffect, useRef, useState } from 'react';

import { Button } from '@yandex-id/components/next/Button';
import { ArrowShortBottom } from '@yandex/ui-icons';

import { Option } from './Option';

import styles from './Select.module.css';

interface SelectProps {
  value: string;
  onChange: (value: string) => void;
  error?: string;
}

const _Select: FC<SelectProps> = (props) => {
  const { value, onChange, children, error } = props;
  const [selectedText, setSelectedText] = useState('');
  const controlRef = useRef<HTMLSelectElement>(null);

  useEffect(() => {
    if (controlRef.current) {
      setSelectedText(controlRef.current.options[controlRef.current.selectedIndex]?.text);
    }
  }, [value]);

  return (
    <div className={styles.root}>
      <div className={styles.inner}>
        <Button
          size="xl"
          after={<ArrowShortBottom className={styles.arrowBottom} />}
          className={styles.button}
        >
          {selectedText}
        </Button>
        <select
          className={styles.control}
          ref={controlRef}
          value={value}
          // eslint-disable-next-line react/jsx-no-bind
          onChange={(event) => onChange(event.target.value)}
        >
          {children}
        </select>
      </div>
      {error && <span className={styles.error}>{error}</span>}
    </div>
  );
};

export const Select = Object.assign(_Select, { Option });
