import { RouterLink } from '@client/shared/libs/router-link';
import { Shortcut as _Shortcut } from '@yandex-id/components';
import { component } from '@yandex-id/components/libs/css-modules';

import colorInfo from './_color/color-info.module.css';
import colorSuccess from './_color/color-success.module.css';
import tall from './_tall/tall.module.css';
import variantAccess from './_variant/variant-access.module.css';
import variantActivity from './_variant/variant-activity.module.css';
import variantCamera from './_variant/variant-camera.module.css';
import variantCat from './_variant/variant-cat.module.css';
import variantDevices from './_variant/variant-devices.module.css';
import variantInsecure from './_variant/variant-insecure.module.css';
import variantPhone from './_variant/variant-phone.module.css';
import variantPin from './_variant/variant-pin.module.css';
import variantSalute from './_variant/variant-salute.module.css';
import variantWand from './_variant/variant-wand.module.css';

export const Shortcut = component(_Shortcut, {
  defaultProps: {
    variant: 'default',
    size: 's',
    tall: false,
    color: null,
  },
  variants: {
    variant: {
      cat: variantCat.root,
      activity: variantActivity.root,
      devices: variantDevices.root,
      access: variantAccess.root,
      insecure: variantInsecure.root,
      phone: variantPhone.root,
      pin: variantPin.root,
      wand: variantWand.root,
      camera: variantCamera.root,
      salute: variantSalute.root,
    },
    tall: tall.root,
    color: {
      info: colorInfo.root,
      success: colorSuccess.root,
    },
  },
});

export const ShortcutLink = component(Shortcut, {
  defaultProps: {
    variant: 'default',
    size: 's',
    as: RouterLink,
    tall: false,
    color: null,
  },
});
