import cx from 'classnames';
import { PointerEvent, forwardRef, useCallback } from 'react';

import { Snackbar as BaseSnackbar, SnackbarProps } from '@yandex-id/components';

import styles from './Snackbar.module.css';

export type { SnackbarProps, SnackbarComponentProps } from '@yandex-id/components';

const Snackbar = forwardRef<HTMLDivElement, SnackbarProps>((props, ref) => {
  const { children, className, ...other } = props;

  // NOTE: Вызываем preventDefault, чтобы при клике по снеку не закрывалась модалку на outside click
  const handlePointerDown = useCallback((event: PointerEvent<HTMLDivElement>) => {
    event.preventDefault();
  }, []);

  return (
    <BaseSnackbar
      ref={ref}
      className={cx(styles.root, className)}
      {...other}
      onPointerDown={handlePointerDown}
    >
      {children}
    </BaseSnackbar>
  );
});

const _Snackbar = Object.assign(Snackbar, {
  Before: BaseSnackbar.Before,
  After: BaseSnackbar.After,
  Content: BaseSnackbar.Content,
  Progress: BaseSnackbar.Progress,
}) as typeof BaseSnackbar;

export { _Snackbar as Snackbar };
